/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws;

import filenet.vw.base.VWUDDIRegistry;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.ws.base.VWUDDIRegistryItem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class VWUDDIBusinessNameDialog
extends VWModalDialog
implements ActionListener,
DocumentListener {
    private String m_internalClassName = "BusinessNameDialog";
    private VWUDDIRegistryItem m_vwUDDIRegistryItem = null;
    private VWUDDIRegistry m_vwUDDIRegistry = null;
    private String m_businessName = null;
    private String m_businessDescription = null;
    private JTextField m_uddiRegistryName = null;
    private JTextField m_businessNameTextField = null;
    private JTextField m_businessDescriptionTextField = null;
    private JButton m_okButton = null;
    private JButton m_cancel = null;
    private boolean m_bCancel = false;

    public VWUDDIBusinessNameDialog(Frame parent, VWUDDIRegistryItem vwUddiRegistryItem) {
        super(parent);
        this.m_vwUDDIRegistryItem = vwUddiRegistryItem;
        if (vwUddiRegistryItem != null) {
            this.m_vwUDDIRegistry = vwUddiRegistryItem.getVWUDDIRegistry();
        }
        if (this.m_vwUDDIRegistry != null) {
            this.m_businessName = this.m_vwUDDIRegistry.getBusinessName();
            this.m_businessDescription = this.m_vwUDDIRegistry.getBusinessDescription();
        }
        this.setupDialogLayout();
    }

    public VWUDDIBusinessNameDialog(Dialog parent, VWUDDIRegistryItem vwUddiRegistryItem) {
        super(parent);
        this.m_vwUDDIRegistryItem = vwUddiRegistryItem;
        if (vwUddiRegistryItem != null) {
            this.m_vwUDDIRegistry = vwUddiRegistryItem.getVWUDDIRegistry();
        }
        if (this.m_vwUDDIRegistry != null) {
            this.m_businessName = this.m_vwUDDIRegistry.getBusinessName();
            this.m_businessDescription = this.m_vwUDDIRegistry.getBusinessDescription();
        }
        this.setupDialogLayout();
    }

    private void setupDialogLayout() {
        GridBagConstraints c = new GridBagConstraints();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setResizable(true);
        Dimension dim = VWStringUtils.stringToDimension("385,275");
        if (dim == null) {
            dim = new Dimension(350, 325);
        }
        this.setSize(dim.width, dim.height);
        this.setVisible(false);
        this.setTitle(VWResource.s_uddiBusinessEntityDialogTitle);
        VWAccessibilityHelper.setAccessibility(this, null, VWResource.s_uddiBusinessEntityDialogTitle, VWResource.s_uddiBusinessEntityDialogTitle);
        this.m_uddiRegistryName = new JTextField();
        this.m_uddiRegistryName.setEditable(false);
        this.m_uddiRegistryName.setBorder(null);
        if (this.m_vwUDDIRegistry != null) {
            this.m_uddiRegistryName.setText(this.m_vwUDDIRegistry.getName());
        }
        VWAccessibilityHelper.setAccessibility(this.m_uddiRegistryName, this, VWResource.s_uddiRegistryNameTextField, VWResource.s_uddiRegistryNameTextField);
        this.m_businessNameTextField = new JTextField();
        this.m_businessNameTextField.setText(this.m_businessName);
        this.m_businessDescriptionTextField = new JTextField();
        this.m_businessDescriptionTextField.setText(this.m_businessDescription);
        VWAccessibilityHelper.setAccessibility(this.m_businessNameTextField, this, VWResource.s_uddiBusinessName, VWResource.s_uddiBusinessName);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(10, 0, 0, 0);
        c.anchor = 23;
        JTextArea description = new JTextArea();
        description.setEditable(false);
        description.setBorder(null);
        description.setWrapStyleWord(true);
        description.setLineWrap(true);
        description.setText(VWResource.s_uddiCreateBusinessEntity);
        Color bgColor = this.getContentPane().getBackground();
        description.setBackground(bgColor);
        VWAccessibilityHelper.setAccessibility(description, this, VWResource.s_description, VWResource.s_description);
        Font boldFont = null;
        Font normalFont = this.getFont();
        if (normalFont != null) {
            boldFont = new Font(normalFont.getName(), 1, normalFont.getSize());
        }
        description.setFont(boldFont);
        mainPanel.add((Component)description, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 0, 0);
        c.anchor = 23;
        JLabel label = new JLabel(VWResource.s_label.toString(VWResource.s_uddiRegistry));
        mainPanel.add((Component)label, c);
        VWAccessibilityHelper.setAccessibility(label, this, VWResource.s_uddiRegistry, VWResource.s_uddiRegistry);
        ++c.gridy;
        c.insets = new Insets(0, 10, 0, 0);
        mainPanel.add((Component)this.m_uddiRegistryName, c);
        VWAccessibilityHelper.setLabelFor(label, this.m_uddiRegistryName);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.insets = new Insets(10, 0, 0, 0);
        label = new JLabel(VWResource.s_businessName);
        mainPanel.add((Component)label, c);
        VWAccessibilityHelper.setAccessibility(label, this, VWResource.s_businessName, VWResource.s_businessName);
        ++c.gridy;
        c.insets = new Insets(0, 10, 0, 0);
        mainPanel.add((Component)this.m_businessNameTextField, c);
        VWAccessibilityHelper.setLabelFor(label, this.m_businessNameTextField);
        ++c.gridy;
        c.insets = new Insets(10, 0, 0, 0);
        label = new JLabel(VWResource.s_businessDescription);
        mainPanel.add((Component)label, c);
        VWAccessibilityHelper.setAccessibility(label, this, VWResource.s_businessDescription, VWResource.s_businessDescription);
        ++c.gridy;
        c.insets = new Insets(0, 10, 0, 0);
        mainPanel.add((Component)this.m_businessDescriptionTextField, c);
        VWAccessibilityHelper.setLabelFor(label, this.m_businessDescriptionTextField);
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_okButton = new JButton(VWResource.s_ok);
        this.m_cancel = new JButton(VWResource.s_cancel);
        panel.add(this.m_okButton);
        panel.add(this.m_cancel);
        VWAccessibilityHelper.setAccessibility(this.m_okButton, this, VWResource.s_ok, VWResource.s_ok);
        VWAccessibilityHelper.setAccessibility(this.m_cancel, this, VWResource.s_cancel, VWResource.s_cancel);
        ++c.gridy;
        mainPanel.add((Component)panel, c);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)mainPanel, "Center");
        if (this.m_businessNameTextField != null) {
            this.m_businessNameTextField.requestDefaultFocus();
            this.m_businessNameTextField.getDocument().addDocumentListener(this);
            this.m_businessNameTextField.addActionListener(this);
        }
        this.m_businessDescriptionTextField.addActionListener(this);
        this.m_okButton.addActionListener(this);
        this.m_cancel.addActionListener(this);
        this.setButtonState();
        this.getRootPane().setDefaultButton(this.m_okButton);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_okButton) {
            if (this.doOk()) {
                this.m_bCancel = false;
                this.setVisible(false);
            }
        } else if (source == this.m_businessNameTextField || source == this.m_businessDescriptionTextField) {
            JButton defaultButton = this.getRootPane().getDefaultButton();
            if (defaultButton != null) {
                defaultButton.doClick();
            }
        } else if (source == this.m_cancel) {
            this.m_bCancel = true;
            this.setVisible(false);
        }
    }

    private boolean doOk() {
        String name = null;
        String description = null;
        if (this.m_businessNameTextField != null) {
            name = this.m_businessNameTextField.getText();
        }
        if (this.m_businessDescriptionTextField != null) {
            description = new String(this.m_businessDescriptionTextField.getText());
        }
        if (name == null || name.length() == 0) {
            return false;
        }
        this.m_businessName = name;
        this.m_businessDescription = description;
        return true;
    }

    public boolean isCanceled() {
        return this.m_bCancel;
    }

    public String getBusinessName() {
        if (this.m_businessName != null && this.m_businessName.length() == 0) {
            this.m_businessName = null;
        }
        return this.m_businessName;
    }

    public String getBusinessDescription() {
        if (this.m_businessDescription != null && this.m_businessDescription.length() > 0) {
            return this.m_businessDescription;
        }
        return null;
    }

    public void addNotify() {
        super.addNotify();
        this.m_businessNameTextField.requestFocus();
    }

    public void insertUpdate(DocumentEvent event) {
        this.setButtonState();
    }

    public void removeUpdate(DocumentEvent event) {
        this.setButtonState();
    }

    public void changedUpdate(DocumentEvent event) {
    }

    private void setButtonState() {
        String tempString;
        if (this.m_okButton == null) {
            return;
        }
        boolean bEnable = false;
        if (this.m_businessNameTextField != null && (tempString = this.m_businessNameTextField.getText()) != null) {
            tempString.trim();
            if (tempString.length() > 0) {
                bEnable = true;
            }
        }
        if (this.m_okButton.isEnabled() != bEnable) {
            this.m_okButton.setEnabled(bEnable);
        }
    }
}

